function design = P33base_1d(k, d, P33base)
%MISC_1D Generates a 1D MISC array.
%Syntax:
%   design = MISC_1d(n, wavelength/2, 'MISC Array');
%Inputs:
%   n - sensor amount.
%   d - Inter-element spacing.
%   name - Custom name of the array. Default is 'MISC array (m)'.
%Outputs:
%   design - An array design struct.
if k <= 7
    error('Sensor amount must larger than 7.');
end
% ========= array configuration ============
% ========= decide spacing
n = floor((k-5)/6);
m = k-3*n-4;

num_array = 6;
mid_count = ceil((1+num_array)/2)-1;
sn_1 = 3;
sn_2 = 1;
n_1 = n;
sn_3 = 3 * n_1+5;
sn_4 = 3;
sn_6 = 3;
sn_5 = 2;
%%%%%%%%%%%%%%%%%%%%%%
n_2 = 2;
n_5 = 2;
n_3 = m;
n_4 = n_1;
n_6 = n_1;
%%%%%%%%%%%%%%%%%%%%%%
interspace_12 = 4;
interspace_23 = 2+3*(n_1);
interspace_34 = sn_4;
interspace_45 = 4;
interspace_56 = 3;


% ========= subarray designs ===========
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%  compute initial position   %%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
for initial_count=1:num_array
    if initial_count==1
        eval(['i_',num2str(initial_count),'=0',';'])
    else 
        eval(['i_',num2str(initial_count),'=i_',num2str(initial_count-1),'+(n_',num2str(initial_count-1),'-1)*sn_',num2str(initial_count-1),'+interspace_',num2str(initial_count-1),num2str(initial_count),';'])
    end 
end 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%  compute sub arrays   %%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
for initial_count=1:num_array
    eval(['sub',num2str(initial_count),'=[]',';'])
    eval(['count1=n_',num2str(initial_count),';'])
    for sub_count=1:count1
        eval(['sub',num2str(initial_count),'(sub_count) = (sub_count-1)','*sn_',num2str(initial_count),';'])
    end
    eval(['sub',num2str(initial_count),'=sub',num2str(initial_count),'+i_',num2str(initial_count),';'])
end 

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%% compute array address  %%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
arr_indices = [];
for p = 1:num_array
    eval(['arr_indices = [ arr_indices sub',num2str(p),'];'])
end
%%%%%%%%%%%%%%%%%%%%%%%%%


if d <= 0 || ~isreal(d)
    error('d must be a positive real number.');
end
if nargin <= 2
    name = sprintf('3 base  array solution 3 %d sensors', k);
elseif ~ischar(name)
    error('Name must be a string.');
end
design.element_indices = arr_indices;
%design.element_indices = union(design.element_indices, (n1*n2+n2+n1-2));
design.element_positions = design.element_indices*d;
design.element_spacing = d;
design.element_count = length(design.element_indices);
design.dim = 1;
design.type = '3base P3 Subarray';
design.name = name;
end